#!/usr/bin/env bash
SOURCE="$0"

while [ -h "$SOURCE"  ]; do 
    DIR="$( cd -P "$( dirname "$SOURCE"  )" && pwd  )"
    SOURCE="$(readlink "$SOURCE")"
	# if $SOURCE was a relative symlink, we need to resolve it relative to the path where the symlink file was located
    [[ $SOURCE != /*  ]] && SOURCE="$DIR/$SOURCE" 
done
DIR="$( cd -P "$( dirname "$SOURCE"  )" && pwd  )"

cd ${DIR}

if [ -d client-logs-patch ] ; then
    echo "install the agent log patch!"
    cd client-logs-patch
    chmod +x install-client-logs.sh
    ./install-client-logs.sh
    cd ${DIR}
fi

if [ -d client-logs-patch ] ; then
    echo "install the agent kernel log patch!"
    cd sniperknl-patch
    chmod +x install-sniperknl-logger.sh
    ./install-sniperknl-logger.sh
    cd ${DIR}
fi

