#!/bin/bash

SOURCE="$0"

while [ -h "$SOURCE"  ]; do 
    DIR="$( cd -P "$( dirname "$SOURCE"  )" && pwd  )"
    SOURCE="$(readlink "$SOURCE")"
	# if $SOURCE was a relative symlink, we need to resolve it relative to the path where the symlink file was located
    [[ $SOURCE != /*  ]] && SOURCE="$DIR/$SOURCE" 
done
DIR="$( cd -P "$( dirname "$SOURCE"  )" && pwd  )"

latest_package_path=#LATEST_PACKAGE_PATH#
sniper_pid_path=/etc/.edr.pid
logger "[sniper] latest package path: ${latest_package_path}"

# delect_backup_package_path=/usr/local/sniper.old.old-${curent_time}
old_backup_package_path=/usr/local/sniper.old.old
backup_package_path=/usr/local/sniper.old
sniper_install_path=/usr/local/sniper

# 停止旧版本的sniper客户端
if [ -f /usr/local/sniper/shutdown.sh ] ; then
	logger "[sniper] sniper stop"
	/usr/local/sniper/shutdown.sh
fi

# 备份旧版本
function backup() {
	logger "[sniper] Back up the old version of the client!"
	rm -rf ${old_backup_package_path}
	mv ${backup_package_path} ${old_backup_package_path}
    cp -r ${sniper_install_path} ${backup_package_path}
}

backup

# 卸载旧版本的安装包
if [ -f /usr/local/sniper/uninstall.sh ] ; then
    logger "[sniper] uninstall client!"
	/usr/local/sniper/uninstall.sh upgrade
fi

if [ -d ${latest_package_path} ] ; then
	#如果解压成功就进最新安装包目录，执行安装脚本
	logger "[sniper] Enter installation directory: ${latest_package_path}!"
	cd ${latest_package_path}
	# 拷贝服务端下发的扩展文件
	cp -r ${backup_package_path}/whitelist.rc .
	cp -r ${backup_package_path}/.server.list .
	cp -r ${backup_package_path}/custom_rules .
	cp -r ${backup_package_path}/.white_path_version .
	cp -r ${backup_package_path}/.network_isolation_status .
	cp -r ${backup_package_path}/.eis_strategy.config .
	cp -r ${backup_package_path}/eis.db .
    if [ -f ${backup_package_path}/config/.data_reducer.config ] ; then
        cp -r ${backup_package_path}/config/.data_reducer.config config
    fi
    if [ -f ${backup_package_path}/config/.ignore.conf ] ; then
        cp -r ${backup_package_path}/config/.ignore.conf config
    fi
else
	#如果安装目录不存在就进入备份目录，进行回滚安装
	logger "[sniper] ${latest_package_path} not found,  Enter to latest package failed!"
	cd ${backup_package_path}
fi

# 安装新版本客户端
logger "[sniper] in `pwd` install package!"
chmod +x install.sh
./install.sh

# 使用原有的keybin进行注册
if [ -f /usr/local/sniper/register.sh ] ; then
	if [ -f ${backup_package_path}/config/key.bin ]; then
		logger "[sniper] Register keybin ${backup_package_path}/config/key.bin"
		/usr/local/sniper/register.sh ${backup_package_path}/config/key.bin upgrade
	fi
fi

# 启动新版本的客户端
if [ -f /usr/local/sniper/startup.sh ] ; then
	logger "sniper start!"
	/usr/local/sniper/startup.sh
fi

sleep 1

# 检查新版本是否正常运行
error_count=0
for k in $(seq 1 10) ; do
	sleep 5
    if [ -f /usr/local/sniper/sniper ] ; then
	    cd /usr/local/sniper/
    	./sniper -s > /dev/null 2>&1
		if [ "X0" != "X$?" ] ; then
			error_count=$(($error_count + 1))
		else
			error_count=0
			break
		fi
	fi
	
	# 如果检查连续五次都没有启动成功，则认为新版本启动失败，回滚到旧版本
	if [ ${error_count} -ge 5 ] ; then
		# 回滚到旧的版本，并启动旧版本，针对启动失败记录到系统message日志
		/usr/local/sbin/sniper/uninstall.sh
		logger "[sniper] The latest version was successfully installed, but an exception was run and a version rollback was required"
		cd ${backup_package_path}
		./install.sh
		/usr/local/sniper/register.sh ${backup_package_path}/config/key.bin upgrade
		/usr/local/sniper/startup.sh
		break
	fi
done

if [ ${error_count} -eq 0 ] ; then
	logger "[sniper] Update successfully"
fi

sniper_pid=`cat ${sniper_pid_path}`
logger "[sniper] Update complete, sniper pid: ${sniper_pid}"

# 删除自身
rm -rf $0
