#!/usr/bin/env bash
SOURCE="$0"
OP="$1"

while [ -h "$SOURCE"  ]; do 
    DIR="$( cd -P "$( dirname "$SOURCE"  )" && pwd  )"
    SOURCE="$(readlink "$SOURCE")"
	# if $SOURCE was a relative symlink, we need to resolve it relative to the path where the symlink file was located
    [[ $SOURCE != /*  ]] && SOURCE="$DIR/$SOURCE" 
done
DIR="$( cd -P "$( dirname "$SOURCE"  )" && pwd  )"

# 强制停止应用层进程
function force_stop() {
    sniper_pid=`ps -ef | grep sniper | grep -v $0 | grep -v sniperknl | grep -v grep | grep -v .sniper_tmp | awk '{print $2}'`
    kill -9 ${sniper_pid}
}

SNIPER_PATH=/usr/local/sniper
if [ ! -d $SNIPER_PATH ] ; then
    SNIPER_PATH=$DIR
fi

if [ ! -f $SNIPER_PATH/sniper ] ; then
    echo "=> command not found $SNIPER_PATH/sniper"
    exit 1
fi

# 当前脚本仅仅应用与应用层的停止，不会停止驱动层
# if [ ! -f $SNIPER_PATH/sniperknl*.ko ] ; then
#     echo "=> driver not found $SNIPER_PATH/sniperknl*.ko"
#     exit 1
# fi

cd $SNIPER_PATH
./sniper -o stop
if [ 0 != $? ] ; then
    if [ "#$OP" == "#force" ] ; then
        logger "[sniper] stoped sniper agent failed, force stop agent!"
        echo "=> stoped sniper agent failed, force stop agent!"
        force_stop
        sleep 3
    else
        exit $?
    fi
fi  

is_install_driver=`lsmod | grep sniperknl | wc -l`
if [ "${is_install_driver}" == "1" ] ; then
    # rmmod sniperknl
    echo "when you uninstall sniper server, the sniperknl will be remove!!!"
fi

exit 0
