#!/usr/bin/env bash
SOURCE="$0"

while [ -h "$SOURCE"  ]; do
    DIR="$( cd -P "$( dirname "$SOURCE"  )" && pwd  )"
    SOURCE="$(readlink "$SOURCE")"
	# if $SOURCE was a relative symlink, we need to resolve it relative to the path where the symlink file was located
    [[ $SOURCE != /*  ]] && SOURCE="$DIR/$SOURCE"
done
DIR="$( cd -P "$( dirname "$SOURCE"  )" && pwd  )"

# SNIPER_PATH=/usr/local/sniper
# if [ ! -d $SNIPER_PATH ] ; then
#     SNIPER_PATH=$DIR
# fi

# if [ ! -f $SNIPER_PATH/sniper ] ; then
#     echo "=> command not found $SNIPER_PATH/sniper"
#     exit 1
# fi

PARAMS=""
OP="start"
KEYBIN=""
DATE=$(date +%Y%m%d)

while (( "$#" )); do
  case "$1" in
    -o|--opearte)
      OP=$2
      echo "operate: $OP"
      shift 2
      ;;
    -k|--key-bin)
      KEYBIN=$2
      echo "keybin: $KEYBIN"
      shift 2
      ;;
    -h|--help)
      echo "usage: $0"
      echo "    -o/--operate  {start|restart|stop|version|status|system|update|install}, default: start"
      echo "    -k/--key-bin  keybin_path"
      echo "    -h/--help     show this"
      shift 1
      ;;
    --) # end argument parsing
      shift
      break
      ;;
    -*|--*=) # unsupported flags
      echo "Error: Unsupported flag $1" >&2
      exit 1
      ;;
    *) # preserve positional arguments
      PARAMS="$PARAMS $1"
      shift
      ;;
  esac
done
# set positional arguments in their proper place
eval set -- "$PARAMS"

function start_sniper() {
  if [ -f /usr/local/sniper/startup.sh ] ; then
    chmod +x /usr/local/sniper/startup.sh
    /usr/local/sniper/startup.sh
  fi
}

function insmod_sniperknl() {
  modinfo sniperknl-*.ko
  insmod sniperknl-*.ko
}

function stop_sniper() {
  if [ -f /usr/local/sniper/shutdown.sh ] ; then
    chmod +x /usr/local/sniper/shutdown.sh
    /usr/local/sniper/shutdown.sh
  fi
}

function rmmod_sniperknl() {
  modinfo sniperknl-*.ko
  is_installed=$(lsmod | grep sniperknl | wc -l)
  used=$(lsmod | grep sniperknl | awk '{print $3}')

  if [ "#${is_installed}" != "#0" ] ; then
    echo "attention, sniperknl used ${used}"
    rmmod sniperknl
  fi
}

function update_sniper() {
  echo ""
}

function sniper_version() {
  if [ -f /usr/local/sniper/sniper ] ; then
    echo "the '/usr/local/sniper/sniper' version:"
    /usr/local/sniper/sniper -v
  fi
  for knl in /usr/local/sniper/sniperknl*.ko
  do
    echo "the '${knl}' verison:"
    modinfo ${knl}
  done
  echo "the system kernel version is $(uname -r)"
}

function sniper_status() {
  if [ -f /usr/local/sniper/sniper ] ; then
    /usr/local/sniper/sniper -s
  fi

  pid_list=$(ps -ef | grep sniper | grep -v $0 | grep -v grep | grep -v sniperknl | grep -v grep | grep -v .sniper_tmp | awk '{print $2}' 2> /dev/null)

  if [ "#${pid_list}" == "#" ] ; then
    echo "the sniper is not running"
    exit 0
  fi

  for pid in ${pid_list[@]}
  do
    proc_info=$(ps aux | grep ${pid} | grep -v grep | awk '{print """ CPU: """ $3"""%""" """ MEM: """$4"""%""" """  VSZ: """$5 """  RSS: """$6}')
    echo name: "sniper"  pid: "$pid" "$proc_info"
  done

}

function system_status() {
  echo "current system disk state: (df -h)"
  df -h
  echo "current system memory state: (free -k)"
  free -k
}

function install() {
  ./install.sh $1
}

function register() {
  if [ "#${_K}" != "#" ] && [ -f "${_K}" ] ; then
    _K=$1
    /usr/local/sniper/register.sh "${_K}"
  fi
}

case $OP in
  start)
    echo "startup the sniper service ..."
    start_sniper
    echo "startup the sniper service is OK, daemon pid: $(cat /etc/.edr.daemon.pid), sniper pid: $(cat /etc/.edr.pid)"
    ;;
  restart)
    echo "stop the sniper service ..."
    stop_sniper
    echo "stop the sniper service is OK."
    sleep 5
    echo "startup the sniper service ..."
    start_sniper
    echo "startup the sniper service is OK, daemon pid: $(cat /etc/.edr.daemon.pid), sniper pid: $(cat /etc/.edr.pid)"
    ;;
  stop)
    echo "stop the sniper service ..."
    stop_sniper
    echo "stop the sniper service is OK."
    ;;
  version)
    sniper_version
    ;;
  status)
    sniper_status
    ;;
  system)
    system_status
    ;;
  insmod)
    insmod_sniperknl
    ;;
  rmmod)
    rmmod_sniperknl
    ;;
  install)
    if [ "#$KEYBIN" != "#" ] ; then 
      install $KEYBIN
    else
      install $KEYBIN
    fi
    ;;
  register)
    register $KEYBIN
    ;;
  *)
    echo "usage: $0 -o/--operate {start|restart|stop|version|status|system|insmod|rmmod|install|register}, default: start"
    ;;
esac
